if (script.onAwake) {
	script.onAwake();
	return;
};
function checkUndefined(property, showIfData){
   for (var i = 0; i < showIfData.length; i++){
       if (showIfData[i][0] && script[showIfData[i][0]] != showIfData[i][1]){
           return;
       }
   }
   if (script[property] == undefined){
      throw new Error('Input ' + property + ' was not provided for the object ' + script.getSceneObject().name);
   }
}
// @input bool editDebugSettings
checkUndefined("editDebugSettings", []);
// @ui {"widget":"group_start", "label":"Debug Statements", "showIf":"editDebugSettings"}
// @input bool printDebugStatements = "false" {"label":"Print Info"}
checkUndefined("printDebugStatements", [["editDebugSettings",true]]);
// @input bool printWarningStatements = "true" {"label":"Print Warnings"}
checkUndefined("printWarningStatements", [["editDebugSettings",true]]);
// @ui {"widget":"group_end"}
// @ui {"widget":"separator"}
// @input bool interactable
checkUndefined("interactable", []);
// @ui {"widget":"separator"}
// @input int alignment = "1" {"widget":"combobox", "values":[{"label":"Left", "value":-1}, {"label":"Right", "value":1}]}
checkUndefined("alignment", []);
// @input Asset.Texture[] _icons {"label":"Icons"}
checkUndefined("_icons", []);
// @ui {"widget":"separator"}
// @input bool startAnimation = true
checkUndefined("startAnimation", []);
// @ui {"widget":"separator"}
// @input bool tooltipEnabled {"label":"Tooltip"}
checkUndefined("tooltipEnabled", []);
// @ui {"widget":"group_start", "label":"Tooltip", "showIf":"tooltipEnabled"}
// @input string tooltipLabel {"label":"Label"}
checkUndefined("tooltipLabel", [["tooltipEnabled",true]]);
// @input int tooltipShowOption = "0" {"label":"Show", "widget":"combobox", "values":[{"label":"Auto", "value":0}, {"label":"Delay", "value":1}, {"label":"Custom (API)", "value":2}]}
checkUndefined("tooltipShowOption", [["tooltipEnabled",true]]);
// @input float tooltipDelay {"label":"Delay", "showIf":"tooltipShowOption", "showIfValue":1}
checkUndefined("tooltipDelay", [["tooltipEnabled",true],["tooltipShowOption",1]]);
// @ui {"widget":"group_end"}
// @ui {"widget":"separator"}
// @input int renderOrder
checkUndefined("renderOrder", []);
// @ui {"widget":"separator"}
// @input bool eventCallbacks
checkUndefined("eventCallbacks", []);
// @ui {"widget":"group_start", "label":"Event Callbacks", "showIf":"eventCallbacks"}
// @input int callbackType = "0" {"widget":"combobox", "values":[{"label":"None", "value":0}, {"label":"Behavior Script", "value":1}, {"label":"Behavior Custom", "value":2}, {"label":"Custom Function", "value":3}]}
checkUndefined("callbackType", [["eventCallbacks",true]]);
// @input Component.ScriptComponent[] onSwitchBehaviors {"showIf":"callbackType", "showIfValue":1}
checkUndefined("onSwitchBehaviors", [["eventCallbacks",true],["callbackType",1]]);
// @input string[] onSwitchCustomTriggers {"showIf":"callbackType", "showIfValue":2}
checkUndefined("onSwitchCustomTriggers", [["eventCallbacks",true],["callbackType",2]]);
// @input Component.ScriptComponent customFunctionScript {"showIf":"callbackType", "showIfValue":3}
// @ui {"widget":"separator", "showIf":"callbackType", "showIfValue":3}
// @input string[] onSwitchFunctions {"showIf":"callbackType", "showIfValue":3}
checkUndefined("onSwitchFunctions", [["eventCallbacks",true],["callbackType",3]]);
// @ui {"widget":"group_end"}
// @input Asset.ObjectPrefab prefabWorld
checkUndefined("prefabWorld", []);
// @input Asset.ObjectPrefab prefabPoints
checkUndefined("prefabPoints", []);
// @typename tooltipComponent
var scriptPrototype = Object.getPrototypeOf(script);
if (!global.BaseScriptComponent){
   function BaseScriptComponent(){}
   global.BaseScriptComponent = BaseScriptComponent;
   global.BaseScriptComponent.prototype = scriptPrototype;
   global.BaseScriptComponent.prototype.__initialize = function(){};
   global.BaseScriptComponent.getTypeName = function(){
       throw new Error("Cannot get type name from the class, not decorated with @component");
   }
}
var Module = require("../../../../../../Modules/Src/Src/Misc/Leaderboard.lsc/CC Resources/SideSwitcherForLeaderboard.lsc/SideSwitcherForLeaderboard");
Object.setPrototypeOf(script, Module.SideSwitcher.prototype);
script.__initialize();
if (script.onAwake) {
   script.onAwake();
}
